/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.CreatePullRequestDialog;
import com.aptana.git.ui.internal.actions.AbstractGithubHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.dialogs.HyperlinkInfoPopupDialog;
import com.aptana.ui.util.UIUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class CreatePullRequestHandler
extends AbstractGithubHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        final GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            throw new ExecutionException(Messages.CreatePullRequestHandler_NoRepoErr);
        }
        IGithubRepository ghRepo = this.getGithubRepo();
        if (ghRepo == null) {
            return null;
        }
        Set repos = CollectionsUtil.newSet((Object[])new IGithubRepository[]{ghRepo});
        IGithubRepository defaultBaseRepo = ghRepo;
        try {
            defaultBaseRepo = ghRepo.getParent();
            if (defaultBaseRepo != null) {
                repos.add(defaultBaseRepo);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            IGithubRepository source = ghRepo.getSource();
            if (source != null) {
                repos.add(source);
                repos.addAll(source.getForks());
            }
        }
        catch (CoreException source) {
            // empty catch block
        }
        IStatus commitsStatus = repo.execute(GitRepository.ReadWrite.READ, new String[]{"log", "-g", "--pretty"});
        String branch = repo.currentBranch();
        String head = String.valueOf(ghRepo.getOwner()) + ':' + branch;
        CreatePullRequestDialog id = new CreatePullRequestDialog(UIUtils.getActiveShell(), branch, commitsStatus.isOK() ? commitsStatus.getMessage() : "", defaultBaseRepo, repos, head);
        if (id.open() == 1) {
            return null;
        }
        final String title = id.getTitle();
        final String body = id.getBody();
        final String baseBranch = id.getBaseBranch();
        final IGithubRepository baseRepo = id.getBaseRepo();
        final IGithubRepository theGhRepo = ghRepo;
        Job job = new Job(Messages.CreatePullRequestHandler_SubmitPRJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final IGithubPullRequest pr = theGhRepo.createPullRequest(title, body, repo, baseRepo, baseBranch, monitor);
                    URL url = null;
                    try {
                        url = pr.getHTMLURL();
                    }
                    catch (MalformedURLException e1) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e1);
                    }
                    final String prURL = url == null ? "" : url.toString();
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            HyperlinkInfoPopupDialog toolTip = new HyperlinkInfoPopupDialog(UIUtils.getActiveShell(), Messages.CreatePullRequestHandler_PRSubmittedTitle, MessageFormat.format(Messages.CreatePullRequestHandler_SuccessMsg, prURL, pr.getNumber()), (SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    CreatePullRequestHandler.viewPullRequest(pr);
                                }
                            });
                            toolTip.open();
                        }
                    });
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

